#!/usr/bin/env bash

# Majordomo for "AVpres" packages.
#
# Copyright (c) 2025-2026 by Reto Kromer <https://reto.ch/>
#
# Released under a 3-Clause BSD License and provided "as is" without warranty
# or support of any kind.


# initialise constants
VERSION='2026-01-02'
SCRIPT_NAME="$(basename "$0")"
AVPRES_FOLDER="${HOME}/.config/AVpres"
BASH_FOLDER="${AVPRES_FOLDER}/Bash_AVpres"
BIN_FOLDER="$(dirname $(which bash_avpres >/dev/null 2>&1) >/dev/null 2>&1)"
MAN_FOLDER="$(dirname $(man -w bash_avpres >/dev/null 2>&1) >/dev/null 2>&1)"

# create a configuration folder, if necessary
[[ -d "${AVPRES_FOLDER}" ]] || mkdir -p "${AVPRES_FOLDER}"

# write "Read_Me.txt"
cat << EOF > "${AVPRES_FOLDER}/Read_Me.txt"
About the “AVpres” configuration folder
---------------------------------------

This folder contains the configuration files you defined for the software
packages programmed by Michal Cohen and Reto Kromer (AV Preservation by
reto.ch). Each package has a folder containing the corresponding configuration
files.

Packages maintained on ${VERSION}:
• Bash_AVpres – Bash Scripts for Audio-Visual Preservation
• MovIm – Encode, decode, play and analyse virtually any moving images
• Spolied_Apples – Emulation of 6502, 65C816, 680x0 and PowerPC-based Apple
  computers and clone

Packages discontinued on 2025-05-02:
• openLTFS – LTFS for both tape drives and DIY tape libraries
• openLTO – Bash scripts to manage LTO cartridges with LTFS
  (some of these may be integrated into “Bash_AVpres” in the future)

Packages discontinued on 2019-01-12 (superseded by “MovIm”):
• openMSMI – Encode, decode, play and analyse multispectral moving images
• openYCoCg – Encode, decode, play and analyse Y’CoCg video
EOF

# write "Bash_AVpres/config.txt" configuration file
cat << EOF > "${BASH_FOLDER}/config.txt"
# Please don't edit me.
# Installed by '${SCRIPT_NAME}' $(TZ='UTC' date +'on %F at %T %Z').
VERSION='${VERSION}'
EOF

# remove the configuration files from obsolete packages
[[ -d "${AVPRES_FOLDER}/openLTFS" ]] || rm -rf "${AVPRES_FOLDER}/openLTFS"
[[ -d "${AVPRES_FOLDER}/openLTO" ]] || rm -rf "${AVPRES_FOLDER}/openLTO"
[[ -d "${AVPRES_FOLDER}/openMSMI" ]] || rm -rf "${AVPRES_FOLDER}/openMSMI"
[[ -d "${AVPRES_FOLDER}/openYCoCg" ]] || rm -rf "${AVPRES_FOLDER}/openYCoCg"

# remove obsolete commands
if [[ -d "${BIN_FOLDER}" ]]; then
  cd "${BIN_FOLDER}"
  [[ -f 'modify_bagit' ]] && rm 'modify_bagit'
  [[ -f 'update_bagit' ]] && rm 'update_bagit'
  [[ -f 'update_manifest' ]] && rm 'update_manifest'
  [[ -f 'ffengine_presets' ]] && rm 'ffengine_presets'
  [[ -f 'engine_ffmprovisr' ]] && rm 'engine_ffmprovisr'
fi

# remove obsolete man pages
if [[ -d "${MAN_FOLDER}" ]]; then
  cd "${MAN_FOLDER}"
  [[ -f 'modify_bagit.1' ]] && rm 'modify_bagit.1'
  [[ -f 'update_bagit.1' ]] && rm 'update_bagit.1'
  [[ -f 'update_manifest.1' ]] && rm 'update_manifest.1'
  [[ -f 'ffengine_presets.1' ]] && rm 'ffengine_presets.1'
  [[ -f 'engine_ffmprovisr.1' ]] && rm 'engine_ffmprovisr.1'
  [[ -f 'dcp2lto.1' ]] && rm 'dcp2lto.1'
  [[ -f 'lto2dcp.1' ]] && rm 'lto2dcp.1'
fi
